<?php
/////////////////////////////////////////////////////////////////
/// getID3() by James Heinrich <info@getid3.org>               //
//  available at http://getid3.sourceforge.net                 //
//            or http://www.getid3.org                         //
/////////////////////////////////////////////////////////////////
// See readme.txt for more details                             //
/////////////////////////////////////////////////////////////////
//                                                             //
// module.archive.doc.php                                      //
// module for analyzing MS Office (.doc, .xls, etc) files      //
// dependencies: NONE                                          //
//                                                            ///
/////////////////////////////////////////////////////////////////

// magic numbers from: http://www.garykessler.net/library/file_sigs.html

class getid3_msoffice
{

	function getid3_msoffice( &$fd, &$ThisFileInfo ) {

		$ThisFileInfo['fileformat'] = 'msoffice';

		fseek( $fd, 512, SEEK_SET );
		$ms_formattest = fread( $fd, 16 );
		switch(substr( $ms_formattest, 0, 4 )) {
			case "\xEC\xA5\xC1\x00":
				$ThisFileInfo['fileformat'] = 'doc';
				$ThisFileInfo['mime_type'] = 'application/msword';
				//$ThisFileInfo['msoffice']['lid'] = getid3_lib::LittleEndian2Int( substr( $ms_formattest, 6, 2 ) );
				break;
			case "\x00\x6E\x1E\xF0":
			case "\x0F\x00\xE8\x03":
			case "\xA0\x46\x1D\xF0":
				$ThisFileInfo['fileformat'] = 'ppt';
				$ThisFileInfo['mime_type'] = 'application/vnd.ms-powerpoint';
				break;
			case "\x09\x08\x10\x00":
				if (preg_match( "/^.{4}\x20\x00\x00\x00/", $ms_formattest )) {
					$ThisFileInfo['fileformat'] = 'xls';
					$ThisFileInfo['mime_type'] = 'application/vnd.ms-excel';
				}
				break;
			case "\xFD\xFF\xFF\xFF":
				if ( $ms_formattest[5] == "\x04" ) {
					$ThisFileInfo['fileformat'] = 'suo';
					$ThisFileInfo['mime_type'] = 'application/vnd.sun.xml.writer.template';
				} else if (preg_match( "/^.{4}(\x0E|\x1C|\x43)\\x00\\x00\\x00/", $ms_formattest )) {
					$ThisFileInfo['fileformat'] = 'ppt';
					$ThisFileInfo['mime_type'] = 'application/vnd.ms-powerpoint';
				} else if (preg_match( "/^(.{4}\x20\\x00\\x00\\x00)|(.{4}(\x10|\x22|\x23|\x28|\x29)\x02)/", $ms_formattest )) {
					$ThisFileInfo['fileformat'] = 'xls';
					$ThisFileInfo['mime_type'] = 'application/vnd.ms-excel';
				} else if (preg_match( "/^.{12}\x04\\x00\\x00\\x00/", $ms_formattest )) {
					$ThisFileInfo['fileformat'] = 'db';	// Thumbs.db
					//$ThisFileInfo['mime_type'] = 'application/vnd.ms-';
				}
		}

		//$ThisFileInfo['error'][] = 'MS Office (.doc, .xls, etc) parsing not enabled in this version of getID3()';
		return true;

	}
}


?>
